/* poly.h: definitions for polygon package */

#ifndef POLY_HDR
#define POLY_HDR

/*
 * mask is an interpolation mask whose kth bit indicates whether the kth
 * double in a Poly_vert is relevant.
 * For example, if the valid attributes are sx, sy, and sz, then set
 *	mask = POLY_MASK(sx) | POLY_MASK(sy) | POLY_MASK(sz);
 */

typedef struct {		/* A BOX (TYPICALLY IN SCREEN SPACE) */
    double x0, x1;		/* left and right */
    double y0, y1;		/* top and bottom */
    double z0, z1;		/* near and far */
} Poly_box;

#ifdef	WINDOW
typedef struct {		/* WINDOW: A DISCRETE 2-D RECTANGLE */
    int x0, y0;			/* xmin and ymin */
    int x1, y1;			/* xmax and ymax (inclusive) */
} Window;
#endif


#define POLY_CLIP_OUT 0		/* polygon entirely outside box */
#define POLY_CLIP_PARTIAL 1	/* polygon partially inside */
#define POLY_CLIP_IN 2		/* polygon entirely inside box */


void	poly_print(/* str, p */);
void	poly_vert_label(/* str, mask */);
void	poly_vert_print(/* str, v, mask */);
int	poly_clip_to_box(/* p1, box */);
void	poly_clip_to_halfspace(/* p, q, index, sign, k, name */);
void	poly_scan(/* p, win, pixelproc */);

#endif
