/************************************************************************/
/*									*/
/*	SGLGLOB.H				(C) 1/94 Ch. Muenkel	*/
/*	Global data of SGL library					*/
/*									*/
/************************************************************************/
/*									*/
/*	Simple Graphics Library						*/
/*	An easy to use interface to the X11 window system		*/
/*									*/
/************************************************************************/
/*									*/
/*	Author:	Christian Muenkel					*/
/*		Present address:					*/
/*		muenkel@carbo.tphys.uni-heidelberg.de			*/
/*		Christian Muenkel					*/
/*		Institut fuer Theoretische Physik			*/
/*		Philosophenweg 19					*/
/*		69120 Heidelberg - Germany				*/
/*									*/
/************************************************************************/
/* version      date            comment                                 */
/*                                                                      */
/* V1.0		 1/94		first implementation 			*/
/* V1.1		 4/94		z-buffer / Gouraud-shading		*/
/*				shading: draw in Image (not pixmap)	*/
/* v1.2		 5/94		new global data structure		*/
/*                                                                      */
/************************************************************************/
/*                                                                      */
/* To do:								*/
/*                                                                      */
/************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<math.h>

#include	"sgl.h"

#define		MAX_X11GD_STRUCT	16
#define	COLOR_MAX	256

/************************************************************************/
/* X11 related global data, which should be accesible from all modules	*/
/************************************************************************/
enum SGL3D_SHADE_MODE { SGL3D_LINES, SGL3D_GOURAUD, SGL3D_UNKNOWN };

struct	X11CommonData {
	Display		*disp;		/* connection to X server	*/
	char		*disp_name;	/* hardware display name	*/
        Screen		*scrn;		/* screen of display <disp>	*/
	int		scrnn;		/* number of screen		*/
	Visual		*vis;		/* visual type			*/
	int		vistype;	/* type of visual (see defines)	*/
	int		depth;		/* bits per pixel of display	*/
	Colormap	colmap;		/* colormap of display		*/
	int		color_stack_top;/* stack of allocated colors	*/
	unsigned long	*color_pixel;	/* pixel values of color	*/
	unsigned short	*color_red,*color_green,*color_blue;
	int	color_foreground;	/* activ color		*/
	int	color_background;	/* background color	*/
	float		rgb_color[3];	/* actual r,g,b color		*/
	};
struct X11GlobalData {
	Display		*disp;		/* connection to X server	*/
	char		*disp_name;	/* hardware display name	*/
        Screen		*scrn;		/* screen of display <disp>	*/
	int		scrnn;		/* number of screen		*/
	Window		win;		/* number of window		*/
	GC		gc;		/* graphic context		*/
	Visual		*vis;		/* visual type			*/
        Pixmap		pm;		/* background pixmap struct	*/
	XImage		*xim;		/* background image struct	*/
	char		*imdata;	/* data information of image	*/
	int		vistype;	/* type of visual (see defines)	*/
	int		depth;		/* bits per pixel of display	*/
	int		win_sx,win_sy;	/* window size in pixels	*/
	int		win_px,win_py;	/* window position in pixels	*/
	int		win_x_min,win_y_min;
	int		win_x_max,win_y_max;
	int		win_idx,win_idy;
	};
struct X113DGlobalData {
        SGLMatrix       (*ms);
	int		ms_ptr;
        float		*zbuf;          /* window z-buffer      */
	float		cop_x,cop_y,cop_z;	/* center of proj.	*/
	float		ref_x,ref_y,ref_z;	/* reference point	*/
	float		view_wx,view_wy;
	float		vdist;
	float		clip_near,clip_far;
	float		clip_top,clip_bot;
	float		clip_left,clip_right;
	enum SGL3D_SHADE_MODE	shading;
        };

/************************************************************************/
/* global data, which should be accesible from all modules		*/
/************************************************************************/
#ifdef	__SGL_MAIN
struct X11GlobalData *(X11GD_all[MAX_X11GD_STRUCT]);	
struct X113DGlobalData *(X11GD3D_all[MAX_X11GD_STRUCT]);
struct X11GlobalData	*X11GD;
struct X113DGlobalData	*X11GD3D;
struct X11CommonData	X11CD[1];
#else
extern struct X11GlobalData *(X11GD_all[MAX_X11GD_STRUCT]);	
extern struct X113DGlobalData *(X11GD3D_all[MAX_X11GD_STRUCT]);
extern struct X11GlobalData	*X11GD;
extern struct X113DGlobalData	*X11GD3D;
extern struct X11CommonData	X11CD[1];
#endif

#ifdef	__SGL_MAIN

int	GD_num = 0;			/* # of X11 windows	*/
int	GD_act;				/* active window	*/

int	flag_initialized = False;	/* not initialized	*/
int	debugging = False;		/* print debugging inf.	*/


#else

extern int	GD_num;			/* # of X11 windows	*/
extern int	GD_act;			/* active window	*/

extern int	flag_initialized;	/* not initialized	*/
extern int	debugging;		/* print debugging inf.	*/

#endif
